# Facing the Spectral Sacrifice Zone

## 

### by José Iglesias García-Arenal, 2024
first published at Concreta

#### 

##### The black merino sheep is at risk of disappearing; the modernization of the textile industry and the development of synthetic fibers along the last century has generated a loss of interest in its dark wool and, consequently, in Spain there are barely 8,000 specimens left. These few flocks maintain the ancestral dark brown color of the Merino, which began to whiten as a result of a selection process that sought a more easily dyed wool. The quality of its fiber made merino fleece an important economic engine in Castile; metaphors such as “textile gold” or “Spanish gold” are used to describe its importance, the Asociación Nacional de Criadores del Ganado Merino (National Association of Merino Cattle Breeders) called it “the oil of the 14th and 15th centuries”[1]. Wool is a soft material (as opposed to others such as bronze or gold, which endure in time and name epochs) in which one can still read the development of a modern, proto-global world-system, configuration of an expansive Eurocentric cosmovision and a colonial commercial order in which commodities and living beings appear entangled in the same body.

There are several projects trying to recover the black merino, some doing it from discourses loaded with a certain imperial nostalgia in which a reactionary, nineteenth-century idea of race and concepts such as purity or autochthonous get emphasized. Other approaches do so through a quest for bonds with the land by applying a community perspective. This is the case of Merineando, a herd of Merino sheep linked to the Extremaduran cooperative ACTYVA that grazes in the La Mosca mountain (about five kilometers from the city of Cáceres), which approaches sheep farming from a holistic perspective intertwined with the preservation of the olive grove ecosystem and the Mediterranean scrubland. Seemingly by chance, this herd of merino grazes right above the second largest lithium deposit in Europe. I came across these sheep trying to map some mining projects and other types of extractivism (such as solar panels’ monocultures) that are transforming the diffuse urbanities of the Iberian southwest and reflect the attempt of capitalist structures to adapt themselves to the energy crisis through investment in digital technologies. I visited them on a spring day after a week of storms that had made the hills sprout a deep green. A group of Merineando cooperative collaborators had just planted some young olive trees next to the meadow where the sheep graze and the removed soil looked dark and fresh. The sheep shunned me as I approached to see them. I wondered which would be closer, the merino sheep that had already moved away to the opposite side of the valley or the lithium lying underground. Feeling my presence between these two entities helped me to read the exploitation of lithium as a new chapter in the expansion of the Eurocentric logics in which the wool trade was part of.

Part of the current planetary geopolitical transformations are taking place around lithium extraction. In Cáceres, where the Australian company Infinity Lithium (and its Spanish subsidiary Extremadura New Energies) is trying to exploit the deposit on which the black merino sheep graze, Europe lands its attempts to maintain economic hegemony through energy and mineral resources independence. As La Mosca extraction project, there are many other mining plans haunting the Iberian Southwest, a land which can be defined as frontier since 13th century, through a conquest capitalism based on dispossession of communal lands and a genocidal and epistemicidal extractivism[2]. It’s a colonial laboratory. The expulsion of Jewish and Muslim populations from the conquered areas at the end of the Middle Ages facilitated a latifundia structure shaped by the accumulation of land ownership and the loss of common lands. This process increased with the 19th century confiscations (usually known as the “ecclesiastical confiscations”, but which affected to many common lands), the repression of peasant movements and privatization of the countryside during Franco’s regime. The accumulation of land ownership is a process that has not yet stopped, continuing to increase[3]. The exploitation of land continues under the futurist name of Extremadura New Energies, the soil becomes a border again, this time not so much of territorial, but of technological and temporal expansion.

The project that Infinity Lithium wants to develop in the outskirts of Cáceres can be consulted on its website: a 3D-modeled video shows the outline of the mine and the subway extraction process[4]. The video approaches lithium from the air, digitally modeled trees generate a leafy texture (without any sheep) in which the camera dives to show lithium: it is represented as a solid mass floating in a virtual space, a dark volume passively waiting to be exploited. Lithium is displayed in an eerie way, it looks like a solid stone, an entity already produced and separated from the world, it’s not a dynamic process after the interaction of multiple geological entities. Lithium appears as a commodity, not as soil. The video ends by explaining the facilities that would be built at the foot of the mine, where the extracted material would be processed (later, tailings would be “injected” back into the voids left underground). If the rendering of lithium simplifies a process of geological scales into a volume waiting for us out of time, the modeling of processing facilities encapsulates a different temporality: progress in the form of factories, an iconography of work to highlight employment as the main attraction that the mining company can offer to the local community. 3D modeling, its polygonal texture and power to define volumes, is one of the truth-building tools of our present (as analyzed by Jara Rocha and Femke Snelting in Volumetric Regimes)[5]. The data generated during lithium search crystallize into an abstract mass with enough weight to concretize a future development. The key to the so-called twin transition lies in the control and production of the necessary technologies for the construction of futures, the development of terminologies, images and narratives that condense all possibilities into a single narrow path, presented as inevitable[6].

“Possibility of recovering degraded areas”, “No visual impact”, “No open pit mine”, “Landscape conservation”, “No dust, noise or vibrations”…. The statements accompanying Infinity Lithium’s promotional video offer a marvelous, innocuous exploitation, to which there is no reason to object. The video is part of a communication strategies trying to position mining companies or large energy lobbies as the only agents capable of solving climate change. Through their participation in events such as the United Nations Climate Change Conference (whose last shameful edition took place in the petro-state of the United Arab Emirates), there is an attempt to protect their interests by controlling the language with which to address the ecological crisis and dismantling the transformative power of public forums. “We facilitate the transition to new sustainable energies,” reads the Infinity Lithium website, where they go on to state that they want to “play a significant role in global decarbonization”[7]. This language is an evolution of the neoliberal “There is no alternative”, adapted to the struggle to generate an economy based on CO2 capture and storage. In times of transformation and hidden conflicts, language becomes slippery, concepts promising unconcreted panaceas appear (such as the “twin transition”), simulating a positive evolution to break with the past (as the NextGenerationEU funds that have injected capital for digitization and energy adaptation) or blurring common values (like “energy communities”, a promising term to promote horizontal and cooperative structures for energy generation and consumption, but which in the hands of large investment funds distort the terms of community or democracy). The digital and energy transition is a struggle to control the temporal imaginaries, the technologies we need to design possible futures.

“Sacrifice zone” is another term belonging to this new green-and-chrome language. It’s an industrial term to indicate a place dedicated to the extraction of materials and energy, production of goods or reception of waste which has suffered heavy environmental alteration and is used to rank territories and life forms under a colonial rationale.

Sacrifice zones work with multiple rhythms: they are implanted on a territory and transform it, but they also carve a niche in our imaginary; they haunt us, imposing a way of relating to the place, fearing its disappearance, living a deferred mourning. Even without materializing on the ground yet, sacrifice zones transmit a particular perception of ecosystems and our place in them. It is the logic of projects, the force of bureaucratic languages generating futuristic scenarios that, as soon as they begin to be sketched out, lead to migration or to social mobilizations —fights often successful, but that do not cease to generate anxiety and exhaustion. Existing merely as a possibility, sacrifice zones extend a shadow over the territory, they are “spectral sacrifice zones”, ghosts that haunt us from the future, transforming our way of perceiving the place we inhabit. It is a colonization of the present from future times through a spectral presence that wears down the bodies inhabiting the threatened territories. This temporality indebts soil and produces anxiety —is not anxiety the main feature of our contemporary presences? — it’s the reverse of the twin transition.

A year ago, I lived an uncanny experience pierced by this colonization of the present from possible futures. The waste management company 3RS Gestión projected a huge industrial landfill in Salvatierra de los Barros, a few kilometers from my home in southern Extremadura. It was an ecocidal project in a dehesa area that would have an important effect in the regional ecosystem. For other reasons, during that time I was able to visit the Nerva landfill —in Huelva, Andalusia— with Lucas Barrero, an activist member of Ecologistas en Acción. We could see the extent of the landfill from above, a quiet and peaceful atmosphere, wastes covered by black plastics and tires. Lucas told me the problem with the landfill is controlling the irregularities in its management and the amount of seepage through the soil, which extend the consequences of waste accumulation beyond the boundaries of the landfill. Observed from the outside, the landfill looked like a flat surface, with some mounds covered by the black plastics. He explained to me that it is located in what used to be a valley. That is: the landfill, in addition to being extensive, is deep, which makes it difficult to be aware of the real volume it occupies. The 3D modeling of the Cáceres lithium came to mind, where lithium appears solid, unrelated to the space where it is located. I thought it wouldn’t be complicated to use the same sonar and 3D modeling technology to generate a three-dimensional image of the landfill and visualize its volume. Infinity Lithium draws a closed form abstracted from its context, but it could be intervened, taking more advantage of 3D technologies to show the seepage, the veins of substances that intertwine with the ground and dilute the boundary between what is a sacrifice zone and what is not. Imagining how these leaks could spread, touching other points and making new landfills germinate, for a moment I felt that what we had in front of us was a vision of the (possible) Salvaleón landfill, the materialization of an already prophesied future that only needs time to grow. This is the effect of progress narratives where energy and digital transition is presented as the only path, a feeling of bondage through certain magic words with the power to define what is inevitable. However, the Salvatierra landfill has been stopped recently by civil movements, by an exhausting work that has left casualties: some people have left this region due to the difficulty of projecting bright futures on it[8].

Time doesn’t move in a straight line, the black merino sheep grazing on the possible future Cáceres lithium are living fossils, but also living testimony of a pre-industrial era: a trace of the curled, subterranean and contradictory movements of time. The collision between the flat texture of the 3D models and the lush, dense, dark wool of the sheep doesn’t draw a firm path, but it fruitfully does tangle the relationship with other forms of life and entities of our common biosphere.

The slogan “EXTREMADURA ES TIERRA DE LUCHA, NO DE SACRIFICIO” [EXTREMADURA IS A LAND OF STRUGGLE, NOT OF SACRIFICE] has strongly permeated Extremadura’s social movements, among which  25 de Marzo Association has highlighted as the articulating agent of the region’s struggles, helping to structure current problems in a historical dimension marked by the latifundia structures and generating a transgenerational solidarity in which the memory of past struggles (such as the mobilizations for the agrarian reform of the 25th of March 1936 that names the collective) do not appear as nostalgic fetishes to build identities, but as the threshold for the “secret agreement between past generations and the present one”, and we should continue: “and the generations to come”[9]. The geological temporality of the sacrifice zones – the time it will take to recover territories damaged by toxic spills, leachates from open-pit mining, by the aridification of the soil caused by large extensions of solar panels… – projects us to scales larger than the human scale, transforming us into future ancestors. The sacrifice zone can produce exhaustion and paralyzing anxiety, or be the entrance to modes of temporal perception and solidarity at temporal scales that twist the linearity of progress.

In his epilogue to Puerca tierra, John Berger analyzes the already vanished peasant time, in which the future appears as a dark and dangerous path, which must be crossed following the trail of an older road “created and maintained by generations of walking feet”[10]. Each step along this path “pushes a thread through the eye of a needle and the thread is tradition” that guides us forward. It is not clear to me how lithium extraction and survival of the black merino can exist simultaneously, but I sense that there are interstices of possibility to be explored: we must work in those cracks to collectivize the technologies and imaginaries that will generate future traditions.

##### Bibliographic notes:

[1] VI Foro Cultura y Ruralidades «Continuidades – Discontinuidades. Artes, creación y ruralidades contemporáneas en Europa», 4-7 July 2023, Cuenca: https://www.youtube.com/watch?v=rPMdSw3d91Q&list=PLmAw6SZis81KD24nXY36CdCZ15bTo uzKA&index=4

[2] In 2023, Extremadura government processed more than 60 mining research permits to search for lithium, copper, wolfram, rare earths and other materials: https://www .hoy .es/extremadura/extremadura-tramita-permisos-investigacion-explotar-minas- 20231111193717-nt.html

[3] https://www.eldiario.es/economia/cultivos-vez-grandes-manos-decadas-concentracion- tierra-espana_1_9152807.html

[4] https://extremaduranewenergies.es/el-proyecto/

[5] ROCHA, JARA and SNELTING, FEMKE: Volumetric Regimes: Material Cultures of Quantified Presence, Open Humanties Press, Londres/Liverpool, 2022 http://www.openhumanitiespress.org/books/titles/volumetric-regimes/

[6] Twin transition is a term to link digital and energy transition and drive sustainable development models, it is commonly used in eco-whitening strategies in industries such as electric cars or underwater mining.

[7] https://www.infinitylithium.com/

[8] VINAGRE, CELESTINO J.: Entierro final del proyecto del macrovertedero en Salvatierra: la empresa renuncia a pleitear más, Hoy, viernes 22 March 2024 https://www.hoy.es/prov-badajoz/entierro-final-proyecto-macrovertedero-salvatierra-empresa-renuncia-20240322211719-nt.html

[9] BENJAMIN, WALTER: Thesis on the Philosophy of History

[10] BERGER, JOHN: Pig Earth


##### Source: https://editorialconcreta.org/en/concreta-journal/concreta-23/entreacto-facing-the-spectral-sacrifice-zone-jose-iglesias-garcia-arenal/

##### Podcast on Jose's work (in Spanish): [https://rwm.macba.cat/es/podcasts/altas-latencias-2/](https://rwm.macba.cat/es/podcasts/altas-latencias-2/)

